<?php
/* 任一文件缺失 → 404 */
if (!file_exists('config.json') || !file_exists('data.csv')) {
    http_response_code(404);
    exit;
}

/* 读取配置 */
$cfg = json_decode(file_get_contents('config.json'), true);
if (!is_array($cfg) || !isset($cfg['title'], $cfg['searchColumns'])) {
    http_response_code(500);
    exit('config.json 格式错误');
}

/* 读取 CSV */
$csv = array_map('str_getcsv', file('data.csv'));
if (!$csv) {
    http_response_code(500);
    exit('data.csv 为空');
}
$headers = array_shift($csv);   // 第一行表头

/* 需要查询的列索引 => 列名 */
$searchMap = [];
foreach ($cfg['searchColumns'] as $idx) {
    if (isset($headers[$idx])) {
        $searchMap[$idx] = $headers[$idx];
    }
}
if (!$searchMap) {
    http_response_code(500);
    exit('无可查询列');
}

$submitted = $_SERVER['REQUEST_METHOD'] === 'POST';
$rows = [];

/* 查询逻辑：完全相等 + AND */
if ($submitted) {
    foreach ($csv as $row) {
        $match = true;
        foreach ($searchMap as $idx => $label) {
            $keyword = trim($_POST["col_$idx"] ?? '');
            if ($keyword === '' || !isset($row[$idx]) || $row[$idx] !== $keyword) {
                $match = false;
                break;
            }
        }
        if ($match) {
            $rows[] = $row;   // 整行返回
        }
    }
}
?>
<!doctype html>
<html lang="zh-CN">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($cfg['title']) ?> - LYKNS</title>
  <link href="https://xwyer.lykns.com.cn/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" href="https://xwyer.lykns.com.cn/pinwheel.ico" type="image/x-icon">
  <style>
    .bd-placeholder-img{font-size:1.125rem;text-anchor:middle;-webkit-user-select:none;-moz-user-select:none;user-select:none;}
    @media (min-width:768px){.bd-placeholder-img-lg{font-size:3.5rem;}}
  </style>
  <link href="https://xwyer.lykns.com.cn/starter-template.css" rel="stylesheet">
</head>
<body>
<div class="container-sm">
  <div class="col-lg-8 mx-auto p-3 py-md-5">
    <header class="d-flex align-items-center pb-3 mb-5 border-bottom">
      <a href="https://www.lykns.com.cn" class="d-flex align-items-center text-dark text-decoration-none">
        <img src="https://xwyer.lykns.com.cn/pinwheel.svg" height="48px"/>
        <span class="fs-4">LYKNS</span>
      </a>
    </header>

    <main>
      <h1 class="mb-4"><?= htmlspecialchars($cfg['title']) ?></h1>

      <!-- 查询表单 -->
      <form method="post" id="queryForm" class="mb-4">
        <?php foreach ($searchMap as $idx => $label): ?>
          <div class="mb-3">
            <label class="form-label"><?= htmlspecialchars($label) ?></label>
            <input type="text"
                   name="col_<?= $idx ?>"
                   class="form-control"
                   value="<?= htmlspecialchars($_POST["col_$idx"] ?? '') ?>"
                   required>
          </div>
        <?php endforeach; ?>
        <button type="submit" class="btn btn-primary">查询</button>
      </form>

      <?php if ($submitted): ?>
        <?php if ($rows): ?>
          <script>document.getElementById('queryForm').style.display='none';</script>
          <?php foreach ($rows as $row): ?>
            <div class="card mb-3">
              <div class="card-body">
                <?php foreach ($headers as $idx => $colName): ?>
                  <div class="mb-1">
                    <strong><?= htmlspecialchars($colName) ?>：</strong>
                    <?= htmlspecialchars($row[$idx] ?? '') ?>
                  </div>
                <?php endforeach; ?>
              </div>
            </div>
          <?php endforeach; ?>
        <?php else: ?>
          <div class="alert alert-danger mt-4" role="alert">
            未找到符合条件的数据，请修改查询条件后重试。
          </div>
        <?php endif; ?>
      <?php endif; ?>
    </main>

    <footer class="pt-5 my-5 text-muted border-top">
      <a>版权所有 &copy; 2025 LYKNS<br></a>
      <a href="https://beian.miit.gov.cn/" target="_blank" rel="nofollow">京ICP备2024076102号-1</a>
      <a href="https://beian.mps.gov.cn/#/query/webSearch?code=11010502055529" target="_blank" rel="nofollow">
        <img src="https://xwyer.lykns.com.cn/备案编号图标.webp" alt="公安备案图标" style="height:1em;vertical-align:text-bottom;margin-right:2px;">
        京公网安备11010502055529
      </a>
    </footer>
  </div>
</div>
</body>
</html>